import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.*;

class LowLevelBinding {
	public static void main(String[] args) {
		IntegerProperty i1 = new SimpleIntegerProperty(1);
		IntegerProperty i2 = new SimpleIntegerProperty(8);

		IntegerBinding ggtBnd = new IntegerBinding() {
			// Instanzinitialisierer
			{
					bind(i1, i2);
			}
			@Override
			protected int computeValue() {
				int rest, a = i1.get(), b = i2.get();
				do {
					rest = a % b;
					a = b;
					b = rest;
				} while (rest > 0);
				return Math.abs(a);
			}
		};
		
		IntegerProperty ggt = new SimpleIntegerProperty();
		ggt.bind(ggtBnd);
		System.out.println("Initialer Wert: " + ggt.getValue());
		ggt.addListener((obs, old, nev) -> System.out.println(" Neuer GGT: " + nev));
		
		System.out.println("Automatische Wertanpassung bei ggt:");
		i1.set(22);
		i1.set(12);
		i1.set(24);
		i1.set(32);
		i1.set(33);
	}
}
